@extends('layouts.app')
@section('title','Detail Karyawan')
@section('page-title','Detail Karyawan')

@section('content')
@php
  $gv = function(array $row, array $alts, $default='-') {
    foreach ($alts as $k) { 
      $v = data_get($row, $k); 
      if (!is_null($v) && $v!=='') return $v; 
    } 
    return $default;
  };
  $fd = function($dateStr) { 
    if(!$dateStr) return '-'; 
    try { 
      $dt=\Carbon\Carbon::parse($dateStr); 
      return $dt->format('d M Y'); 
    } catch(\Throwable $e){ 
      return $dateStr; 
    } 
  };
  $p = $emp['personal'] ?? []; 
  $e = $emp['employment'] ?? [];
@endphp

<div class="space-y-8">

  <!-- Back button at top -->
  <div>
    <a href="{{ route('talenta.employees.index') }}" 
       class="inline-flex items-center gap-2 px-5 py-2 rounded-full bg-gradient-to-r from-indigo-500 to-sky-500 text-white font-medium shadow-md hover:shadow-lg hover:scale-105 transition">
      ← Kembali
    </a>
  </div>

  <!-- Profile Header -->
  <div class="bg-gradient-to-r from-indigo-600 to-sky-500 text-white rounded-3xl shadow-xl p-8 flex flex-col md:flex-row justify-between items-center">
    <div class="space-y-3 max-w-xl">
      <h2 class="text-4xl font-extrabold drop-shadow">{{ $gv($p,['first_name']) }} {{ $gv($p,['last_name']) }}</h2>
      <div class="flex flex-wrap gap-3 text-sm">
        <span class="bg-white/20 px-3 py-1 rounded-full">User ID: {{ $emp['user_id'] ?? '-' }}</span>
        <span class="bg-white/20 px-3 py-1 rounded-full">Employee ID: {{ $gv($e,['employee_id']) }}</span>
      </div>
    </div>
    @if(!empty($p['avatar']))
      <img src="{{ $p['avatar'] }}" 
           class="w-36 h-36 rounded-full object-cover border-4 border-white shadow-lg cursor-pointer hover:scale-105 transition"
           alt="avatar"
           onclick="openModal('{{ $p['avatar'] }}')">
    @else
      <div class="w-36 h-36 rounded-full bg-white/30 flex items-center justify-center text-5xl font-bold shadow-lg">
        {{ strtoupper(substr($gv($p,['first_name']),0,1)) }}
      </div>
    @endif
  </div>

  <!-- Info Cards -->
  <div class="grid md:grid-cols-2 gap-8">
    <!-- Employment -->
    <div class="bg-white rounded-2xl shadow-lg hover:shadow-2xl transition overflow-hidden">
      <div class="px-5 py-3 bg-slate-50 border-b font-semibold text-slate-700">🏢 Employment</div>
      <div class="p-5 text-sm space-y-3">
        @foreach([
          '🏬 Branch' => $gv($e,['branch']),
          '🏢 Organization' => $gv($e,['organization_name']),
          '💼 Job position' => $gv($e,['job_position','job_title']),
          '📊 Job level' => $gv($e,['job_level']),
          '📌 Employment status' => $gv($e,['employment_status','status']),
          '✅ Status' => $gv($e,['status']),
          '📅 Join date' => $fd($gv($e,['join_date'])),
          '📅 End date' => $fd($gv($e,['end_date'])),
          '🖊️ Sign date' => $fd($gv($e,['sign_date'])),
          '🚪 Resign date' => $fd($gv($e,['resign_date'])),
          '🔖 Barcode' => $gv($p,['barcode'])
        ] as $label => $value)
          <div class="flex justify-between border-b last:border-0 pb-2">
            <span class="font-medium text-slate-600">{{ $label }}</span>
            <span class="text-slate-700">{{ $value }}</span>
          </div>
        @endforeach
      </div>
    </div>

    <!-- Personal -->
    <div class="bg-white rounded-2xl shadow-lg hover:shadow-2xl transition overflow-hidden">
      <div class="px-5 py-3 bg-slate-50 border-b font-semibold text-slate-700">👤 Personal</div>
      <div class="p-5 text-sm space-y-3">
        @foreach([
          '📧 Email' => $gv($p,['email']),
          '📱 Phone' => $gv($p,['mobile_phone','phone']),
          '🎂 Birth date' => $fd($gv($p,['birth_date'])),
          '🌍 Birth place' => $gv($p,['birth_place']),
          '🏠 Address' => $gv($p,['address']),
          '🙏 Religion' => $gv($p,['religion']),
          '⚧ Gender' => $gv($p,['gender']),
          '💍 Marital status' => $gv($p,['marital_status']),
          '🆔 NIK' => $gv($p,['nik','identity_number'])
        ] as $label => $value)
          <div class="flex justify-between border-b last:border-0 pb-2">
            <span class="font-medium text-slate-600">{{ $label }}</span>
            <span class="text-slate-700">{{ $value }}</span>
          </div>
        @endforeach
      </div>
    </div>
  </div>

  <!-- Raw JSON -->
  <details class="group">
    <summary class="cursor-pointer text-slate-600 hover:text-slate-800 font-semibold">
      📄 Lihat RAW JSON
    </summary>
    <div class="relative mt-3">
      <button 
        onclick="navigator.clipboard.writeText(document.getElementById('rawJson').innerText)" 
        class="absolute top-2 right-2 px-3 py-1 text-xs rounded bg-indigo-600 text-white hover:bg-indigo-500 shadow">
        Copy
      </button>
      <pre id="rawJson" class="text-xs bg-slate-50 p-4 rounded-lg overflow-auto max-h-96 border">
{{ json_encode($raw ?? $emp, JSON_PRETTY_PRINT|JSON_UNESCAPED_UNICODE) }}
      </pre>
    </div>
  </details>
</div>

<!-- Modal for Avatar -->
<div id="imgModal" 
     class="fixed inset-0 bg-black/80 hidden items-center justify-center z-50 transition-opacity duration-300"
     onclick="closeModal(event)">
  <span class="absolute top-6 right-8 text-white text-5xl cursor-pointer select-none">&times;</span>
  <img id="modalImg" 
       class="max-h-[90%] max-w-[90%] rounded-2xl shadow-2xl border-4 border-white transform scale-95 opacity-0 transition duration-300" 
       alt="Employee Image">
</div>

<script>
  function openModal(src) {
    const modal = document.getElementById("imgModal");
    const img = document.getElementById("modalImg");
    img.src = src;
    modal.classList.remove("hidden");
    modal.classList.add("flex");
    setTimeout(() => {
      img.classList.remove("scale-95", "opacity-0");
      img.classList.add("scale-100", "opacity-100");
    }, 10);
  }

  function closeModal(e = null) {
    const modal = document.getElementById("imgModal");
    const img = document.getElementById("modalImg");
    if (!e || e.target.id === "imgModal" || e.target.tagName === "SPAN") {
      img.classList.add("scale-95", "opacity-0");
      setTimeout(() => {
        modal.classList.add("hidden");
        modal.classList.remove("flex");
      }, 200);
    }
  }

  document.addEventListener("keydown", function(e) {
    if (e.key === "Escape") closeModal();
  });
</script>
@endsection
